<?php
/* ================= CONFIG ================= */
$BOT_TOKEN = "YOUR_TELEGRAM_BOT_TOKEN";
$DEFAULT_GITHUB_TOKEN = "YOUR_GITHUB_TOKEN"; // fallback
$MAX_SIZE_MB = 45;

$FORCE_CHANNELS = ['@channel_one','@channel_two'];

$API = "https://api.telegram.org/bot$BOT_TOKEN/";
$DATA_FILE = __DIR__.'/data.json';
$USER_FILE = __DIR__.'/userid.txt';

/* ================= LANG ================= */
$LANGS = [
 'en'=>[
  'start'=>"Send GitHub repo link",
  'join'=>"❌ Join required channels to use this bot",
  'branch'=>"Choose branch",
  'down'=>"Downloading",
  'big'=>"❌ Repo too large",
  'token_saved'=>"✅ GitHub token saved",
  'token_del'=>"🗑 Token deleted"
 ],
 'ta'=>[
  'start'=>"GitHub link அனுப்புங்கள்",
  'join'=>"❌ இந்த bot பயன்படுத்த channel-களில் join செய்ய வேண்டும்",
  'branch'=>"Branch தேர்வு செய்யவும்",
  'down'=>"பதிவிறக்கம் செய்கிறது",
  'big'=>"❌ Repo மிகப் பெரியது",
  'token_saved'=>"✅ GitHub token சேமிக்கப்பட்டது",
  'token_del'=>"🗑 Token நீக்கப்பட்டது"
 ]
];

/* ================= INIT ================= */
if(!file_exists($DATA_FILE)) file_put_contents($DATA_FILE,'{}');
if(!file_exists($USER_FILE)) file_put_contents($USER_FILE,'');

$data=json_decode(file_get_contents($DATA_FILE),true);

/* ================= HELPERS ================= */
function saveData($d){global $DATA_FILE;file_put_contents($DATA_FILE,json_encode($d,JSON_PRETTY_PRINT));}
function api($m,$p=[]){global $API;$c=curl_init($API.$m);curl_setopt_array($c,[CURLOPT_RETURNTRANSFER=>1,CURLOPT_POST=>1,CURLOPT_POSTFIELDS=>$p]);$r=curl_exec($c);curl_close($c);return json_decode($r,true);}
function checkJoin($uid){
 global $FORCE_CHANNELS;
 foreach($FORCE_CHANNELS as $ch){
  $r=api('getChatMember',['chat_id'=>$ch,'user_id'=>$uid]);
  if(!isset($r['result']['status'])||in_array($r['result']['status'],['left','kicked'])) return false;
 }
 return true;
}
function repoSizeMB($o,$r,$t){
 $c=curl_init("https://api.github.com/repos/$o/$r");
 curl_setopt_array($c,[CURLOPT_RETURNTRANSFER=>1,CURLOPT_HTTPHEADER=>["User-Agent:TG","Authorization: token $t"]]);
 $d=json_decode(curl_exec($c),true);curl_close($c);
 return ($d['size']??0)/1024;
}
function stream($url,$file,$t){
 $f=fopen($file,'w');
 $c=curl_init($url);
 curl_setopt_array($c,[CURLOPT_FILE=>$f,CURLOPT_FOLLOWLOCATION=>1,CURLOPT_HTTPHEADER=>["User-Agent:TG","Authorization: token $t"]]);
 curl_exec($c);curl_close($c);fclose($f);
}

/* ================= UPDATE ================= */
$u=json_decode(file_get_contents('php://input'),true);
if(!$u) exit;

/* ================= MESSAGE ================= */
if(isset($u['message'])){
 $m=$u['message'];$cid=$m['chat']['id'];$uid=$m['from']['id'];$txt=trim($m['text']??'');

 if(!in_array($uid,file($USER_FILE,FILE_IGNORE_NEW_LINES))) file_put_contents($USER_FILE,$uid."\n",FILE_APPEND);
 if(!isset($data[$cid])){$data[$cid]=['lang'=>'en'];saveData($data);}
 $L=$LANGS[$data[$cid]['lang']];

 if(!checkJoin($uid)){api('sendMessage',['chat_id'=>$cid,'text'=>$L['join']]);exit;}

 if($txt==='/start'){api('sendMessage',['chat_id'=>$cid,'text'=>$L['start']]);exit;}

 if(strpos($txt,'/settoken ')===0){
  $data[$cid]['github_token']=trim(substr($txt,10));saveData($data);
  api('sendMessage',['chat_id'=>$cid,'text'=>$L['token_saved']]);exit;
 }

 if($txt==='/deltoken'){
  unset($data[$cid]['github_token']);saveData($data);
  api('sendMessage',['chat_id'=>$cid,'text'=>$L['token_del']]);exit;
 }

 if(preg_match('#github.com/([^/]+)/([^/]+)#',$txt,$m)){
  $o=$m[1];$r=str_replace('.git','',$m[2]);
  $token=$data[$cid]['github_token']??$DEFAULT_GITHUB_TOKEN;
  if(repoSizeMB($o,$r,$token)>$MAX_SIZE_MB){api('sendMessage',['chat_id'=>$cid,'text'=>$L['big']]);exit;}
  api('sendMessage',['chat_id'=>$cid,'text'=>$L['branch'],'reply_markup'=>json_encode(['inline_keyboard'=>[[['text'=>'main','callback_data'=>"$o|$r|main"],['text'=>'master','callback_data'=>"$o|$r|master"]]]])]);
 }
}

/* ================= CALLBACK ================= */
if(isset($u['callback_query'])){
 $c=$u['callback_query'];[$o,$r,$b]=explode('|',$c['data']);
 $cid=$c['message']['chat']['id'];$L=$LANGS[$data[$cid]['lang']];
 $token=$data[$cid]['github_token']??$DEFAULT_GITHUB_TOKEN;

 $msg=api('sendMessage',['chat_id'=>$cid,'text'=>$L['down']]);
 $file=sys_get_temp_dir()."/$r-$b.zip";
 stream("https://api.github.com/repos/$o/$r/zipball/$b",$file,$token);
 api('sendDocument',['chat_id'=>$cid,'document'=>new CURLFile($file)]);
 unlink($file);
}
?>